{********************************************
; File: Video.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT VIDEO;
INTERFACE
USES TYPES;
CONST

vdVideoOverlay = $01;
vdFrameGrabber = $02;
vdInVStandards = $03;
vdOutVStandards = $04;
vdKeyDissLevels = $05;
vdNKeyDissLevels = $06;
vdAdjSideEffect = $07;
vdKeyColorBits = $08;
vdInHueAdj = $09;
vdInSatAdj = $0A;
vdInContrastAdj = $0B;
vdInBrightAdj = $0C;
vdOutSetup = $0D;
vdOutChromaFltr = $0E;
vdOutExtBlank = $0F;
vdKeyEnhDiss = $10;
vdLineInterrupt = $11;
vdGGBus = $12;
vdDualOut = $13;
vdTextMonoOver = $14;
vdGenlock = $32;
vdVideoDetect = $33;
vdGenlocked = $34;
vdAdjInc = $50;
vdAdjDec = $51;
vdAdjSave = $52;
vdAvail = $01;
vdNotAvail = $00;
vdYes = $01;
vdNo = $00;
vdOn = $01;
vdOff = $00;
vdNil = $00;
vdFalse = $00;
vdTrue = $01;
vdKColorEnable = $64;
vdVerticalBlank = $82;
vdMainPageLin = $C8;
vdRAMPageSel = $C9;
vdVBLInterrupt = $CA;
vdInterlaceMode = $CB;
vdClearVBLInt = $CC;
vdClearLineInt = $CD;
vdDisplayField = $CE;
vdVBLIntRequest = $CF;
vdLineIntRequest = $D0;
vdNone = $00;
vdNTSC = $01;
vdPAL = $02;
vdSECAM = $04;
vdSNTSC = $08;
vdSPAL = $10;
vdSSECAM = $20;
vdRGB60 = $40;
vdRGB50 = $80;
vdAux = $00;
vdMain = $10;
vdInterlace = $30;
vdField1 = $01;
vdField0 = $00;
vdEnable = $01;
vdDisable = $00;
vdExternal = $00;
vdGraphics = $01;
vdVBlank = $01;
vdActiveVideo = $00;

{ Error Codes }
vdNoVideoDevice = $2110;  { no video device was found }
vdAlreadyStarted = $2111;  { Video tool set already started }
vdInvalidSelector = $2112;  { an invalid selector was specified }
vdInvalidParam = $2113;  { an invalid parameter was specified }
vdUnImplemented = $21FF;  { an unimplemented tool set routine was called }
PROCEDURE VDBootInit   ;
FUNCTION VDGetFeatures ( videoSelector:Integer) : Integer ;
PROCEDURE VDGGControl ( videoSelector:Integer; gGCtlValue:Integer)  ;
FUNCTION VDGGStatus ( videoSelector:Integer) : Integer ;
PROCEDURE VDInControl ( videoSelector:Integer; inputCtlValue:Integer)  ;
PROCEDURE VDInConvAdj ( videoSelector:Integer; adjustFunction:Integer)  ;
FUNCTION VDInGetStd  : Integer ;
PROCEDURE VDInSetStd ( inputStandard:Integer)  ;
FUNCTION VDInStatus ( videoSelector:Integer) : Integer ;
PROCEDURE VDKeyControl ( videoSelector:Integer; keyerCtlValue:Integer)  ;
FUNCTION VDKeyGetKBCol  : Integer ;
FUNCTION VDKeyGetKDiss  : Integer ;
FUNCTION VDKeyGetKGCol  : Integer ;
FUNCTION VDKeyGetKRCol  : Integer ;
FUNCTION VDKeyGetNKDiss  : Integer ;
PROCEDURE VDKeySetKCol ( redValue:Integer; greenValue:Integer; blueValue:Integer)  ;
PROCEDURE VDKeySetKDiss ( kDissolve:Integer)  ;
PROCEDURE VDKeySetNKDiss ( nonKeyDissolve:Integer)  ;
FUNCTION VDKeyStatus ( videoSelector:Integer) : Integer ;
PROCEDURE VDOutControl ( videoSelector:Integer; outCtlValue:Integer)  ;
FUNCTION VDOutGetStd  : Integer ;
PROCEDURE VDOutSetStd ( outStandard:Integer)  ;
FUNCTION VDOutStatus ( videoSelector:Integer) : Integer ;
PROCEDURE VDReset   ;
PROCEDURE VDShutDown   ;
PROCEDURE VDStartUp   ;
FUNCTION VDStatus  : Boolean ;
FUNCTION VDVersion  : Integer ;
IMPLEMENTATION
END.
